<?php

/**
 * iOS App API Routes
 * Tüm route'lar /api/ios/ prefix'i ile erişilir
 *
 * Personel API'leri: /api/ios/personel/* - Sadece personel rolü erişebilir
 */

use App\Http\Controllers\Api\IosApi\AuthController as IosAuthController;
use App\Http\Controllers\Api\IosApi\DashboardController as IosDashboardController;
use App\Http\Controllers\Api\IosApi\AppointmentController as IosAppointmentController;
use App\Http\Controllers\Api\IosApi\AppointmentRequestController as IosAppointmentRequestController;
use App\Http\Controllers\Api\IosApi\CashboxController as IosCashboxController;
use App\Http\Controllers\Api\IosApi\InvoiceController as IosInvoiceController;
use App\Http\Controllers\Api\IosApi\CustomerController as IosCustomerController;
use App\Http\Controllers\Api\IosApi\ServiceController as IosServiceController;
use App\Http\Controllers\Api\IosApi\StaffController as IosStaffController;
use App\Http\Controllers\Api\IosApi\RoomController as IosRoomController;
use App\Http\Controllers\Api\IosApi\ReportController as IosReportController;
use App\Http\Controllers\Api\IosApi\NotificationController as IosNotificationController;

// Public
Route::post('/login', [IosAuthController::class, 'login'])->name('api.ios.login');

// Auth required
Route::middleware('auth:sanctum')->group(function () {
    Route::post('/logout', [IosAuthController::class, 'logout'])->name('api.ios.logout');
    Route::get('/me', [IosAuthController::class, 'me'])->name('api.ios.me');
    Route::put('/me', [IosAuthController::class, 'updateProfile'])->name('api.ios.me.update');
    Route::post('/me/delete-otp', [IosAuthController::class, 'sendDeleteOtp'])->name('api.ios.me.delete-otp');
    Route::post('/me/verify-delete-otp', [IosAuthController::class, 'verifyDeleteOtp'])->name('api.ios.me.verify-delete-otp');
    Route::post('/me/delete', [IosAuthController::class, 'deleteAccount'])->name('api.ios.me.delete');

    Route::get('/dashboard', [IosDashboardController::class, 'index'])->name('api.ios.dashboard');

    Route::get('/appointments', [IosAppointmentController::class, 'index'])->name('api.ios.appointments.index');
    Route::get('/appointment-requests', [IosAppointmentRequestController::class, 'index'])->name('api.ios.appointment-requests.index');
    Route::post('/appointment-requests/{id}/approve', [IosAppointmentRequestController::class, 'approve'])->name('api.ios.appointment-requests.approve');
    Route::post('/appointment-requests/{id}/reject', [IosAppointmentRequestController::class, 'reject'])->name('api.ios.appointment-requests.reject');
    Route::get('/appointments/calendar', [IosAppointmentController::class, 'calendar'])->name('api.ios.appointments.calendar');
    Route::get('/appointments/check-availability', [IosAppointmentController::class, 'checkAvailability'])->name('api.ios.appointments.check-availability');
    Route::post('/appointments', [IosAppointmentController::class, 'store'])->name('api.ios.appointments.store');
    Route::get('/appointments/{id}', [IosAppointmentController::class, 'show'])->name('api.ios.appointments.show');
    Route::put('/appointments/{id}', [IosAppointmentController::class, 'update'])->name('api.ios.appointments.update');
    Route::post('/appointments/{id}/approve', [IosAppointmentController::class, 'approve'])->name('api.ios.appointments.approve');
    Route::post('/appointments/{id}/cancel', [IosAppointmentController::class, 'cancel'])->name('api.ios.appointments.cancel');
    Route::post('/appointments/{id}/complete', [IosAppointmentController::class, 'complete'])->name('api.ios.appointments.complete');

    Route::get('/cashbox', [IosCashboxController::class, 'index'])->name('api.ios.cashbox.index');
    Route::post('/cashbox/income', [IosCashboxController::class, 'storeIncome'])->name('api.ios.cashbox.income');
    Route::post('/cashbox/expense', [IosCashboxController::class, 'storeExpense'])->name('api.ios.cashbox.expense');

    Route::get('/invoices', [IosInvoiceController::class, 'index'])->name('api.ios.invoices.index');
    Route::get('/invoices/{id}', [IosInvoiceController::class, 'show'])->name('api.ios.invoices.show');
    Route::get('/invoices/{id}/pdf', [IosInvoiceController::class, 'downloadPdf'])->name('api.ios.invoices.pdf');

    Route::get('/customers', [IosCustomerController::class, 'index'])->name('api.ios.customers.index');
    Route::get('/customers/search', [IosCustomerController::class, 'search'])->name('api.ios.customers.search');
    Route::post('/customers', [IosCustomerController::class, 'store'])->name('api.ios.customers.store');
    Route::get('/customers/{id}', [IosCustomerController::class, 'show'])->name('api.ios.customers.show');
    Route::put('/customers/{id}', [IosCustomerController::class, 'update'])->name('api.ios.customers.update');

    Route::get('/services', [IosServiceController::class, 'index'])->name('api.ios.services.index');
    Route::get('/service-categories', [IosServiceController::class, 'categories'])->name('api.ios.service-categories.index');
    Route::post('/services', [IosServiceController::class, 'store'])->name('api.ios.services.store');
    Route::get('/services/{id}', [IosServiceController::class, 'show'])->name('api.ios.services.show');
    Route::put('/services/{id}', [IosServiceController::class, 'update'])->name('api.ios.services.update');
    Route::delete('/services/{id}', [IosServiceController::class, 'destroy'])->name('api.ios.services.destroy');

    Route::get('/staff', [IosStaffController::class, 'index'])->name('api.ios.staff.index');
    Route::post('/staff', [IosStaffController::class, 'store'])->name('api.ios.staff.store');
    Route::get('/staff/{id}', [IosStaffController::class, 'show'])->name('api.ios.staff.show');
    Route::put('/staff/{id}', [IosStaffController::class, 'update'])->name('api.ios.staff.update');
    Route::delete('/staff/{id}', [IosStaffController::class, 'destroy'])->name('api.ios.staff.destroy');
    Route::get('/staff/{id}/leave-preview', [IosStaffController::class, 'leavePreview'])->name('api.ios.staff.leave-preview');
    Route::post('/staff/{id}/leave', [IosStaffController::class, 'setLeave'])->name('api.ios.staff.leave.store');
    Route::delete('/staff/{id}/leave', [IosStaffController::class, 'deleteLeave'])->name('api.ios.staff.leave.delete');

    Route::get('/rooms', [IosRoomController::class, 'index'])->name('api.ios.rooms.index');
    Route::post('/rooms', [IosRoomController::class, 'store'])->name('api.ios.rooms.store');
    Route::get('/rooms/{id}', [IosRoomController::class, 'show'])->name('api.ios.rooms.show');
    Route::put('/rooms/{id}', [IosRoomController::class, 'update'])->name('api.ios.rooms.update');
    Route::delete('/rooms/{id}', [IosRoomController::class, 'destroy'])->name('api.ios.rooms.destroy');

    Route::get('/reports/monthly-appointments', [IosReportController::class, 'monthlyAppointments'])->name('api.ios.reports.monthly-appointments');
    Route::get('/reports/monthly-revenue', [IosReportController::class, 'monthlyRevenue'])->name('api.ios.reports.monthly-revenue');
    Route::get('/reports/weekly', [IosReportController::class, 'weekly'])->name('api.ios.reports.weekly');

    Route::get('/notifications', [IosNotificationController::class, 'index'])->name('api.ios.notifications.index');
    Route::get('/notifications/unread-count', [IosNotificationController::class, 'unreadCount'])->name('api.ios.notifications.unread-count');
    Route::post('/notifications/{id}/read', [IosNotificationController::class, 'markAsRead'])->name('api.ios.notifications.read');
    Route::post('/notifications/read-all', [IosNotificationController::class, 'markAllAsRead'])->name('api.ios.notifications.read-all');

    /*
    |--------------------------------------------------------------------------
    | Personel API - Sadece personel rolü erişebilir
    |--------------------------------------------------------------------------
    | Personel sadece kendi randevularını, hizmetlerini ve odalarını görür.
    | /api/ios/personel/dashboard, /api/ios/personel/appointments vb.
    */
    Route::prefix('personel')->middleware('personel')->name('api.ios.personel.')->group(function () {
        Route::get('/me', [IosAuthController::class, 'me'])->name('me');
        Route::put('/me', [IosAuthController::class, 'updateProfile'])->name('me.update');
        Route::get('/dashboard', [IosDashboardController::class, 'index'])->name('dashboard');
        Route::get('/appointments', [IosAppointmentController::class, 'index'])->name('appointments.index');
        Route::get('/appointments/calendar', [IosAppointmentController::class, 'calendar'])->name('appointments.calendar');
        Route::get('/appointments/{id}', [IosAppointmentController::class, 'show'])->name('appointments.show');
        Route::post('/appointments/{id}/approve', [IosAppointmentController::class, 'approve'])->name('appointments.approve');
        Route::post('/appointments/{id}/cancel', [IosAppointmentController::class, 'cancel'])->name('appointments.cancel');
        Route::post('/appointments/{id}/complete', [IosAppointmentController::class, 'complete'])->name('appointments.complete');
        Route::get('/services', [IosServiceController::class, 'index'])->name('services.index');
        Route::get('/services/{id}', [IosServiceController::class, 'show'])->name('services.show');
        Route::get('/rooms', [IosRoomController::class, 'index'])->name('rooms.index');
        Route::get('/rooms/{id}', [IosRoomController::class, 'show'])->name('rooms.show');
        Route::get('/notifications', [IosNotificationController::class, 'index'])->name('notifications.index');
        Route::get('/notifications/unread-count', [IosNotificationController::class, 'unreadCount'])->name('notifications.unread-count');
        Route::post('/notifications/{id}/read', [IosNotificationController::class, 'markAsRead'])->name('notifications.read');
    });
});
