<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Api\V1\AuthController;
use App\Http\Controllers\Api\V1\AppointmentController;
use App\Http\Controllers\Api\V1\CustomerController;
use App\Http\Controllers\Api\V1\ServiceController;
use App\Http\Controllers\Api\V1\StaffController;
use App\Http\Controllers\Api\V1\RoomController;
use App\Http\Controllers\Api\V1\DashboardController;
use App\Http\Controllers\Api\V1\NotificationController;

/*
|--------------------------------------------------------------------------
| API v1 Routes
|--------------------------------------------------------------------------
|
| Clean Architecture API Routes for Mobile App
| All routes are prefixed with /api/v1
|
*/

// Public routes
Route::post('/login', [AuthController::class, 'login'])->name('api.v1.login');
Route::post('/register', [AuthController::class, 'register'])->name('api.v1.register');

// Protected routes
Route::middleware('auth:sanctum')->group(function () {
    
    // Auth routes
    Route::post('/logout', [AuthController::class, 'logout'])->name('api.v1.logout');
    Route::get('/me', [AuthController::class, 'me'])->name('api.v1.me');
    
    // Dashboard
    Route::get('/dashboard', [DashboardController::class, 'index'])->name('dashboard');
    
    // Appointments
    Route::apiResource('appointments', AppointmentController::class);
    Route::get('/appointments/upcoming', [AppointmentController::class, 'upcoming'])->name('appointments.upcoming');
    Route::post('/appointments/{id}/approve', [AppointmentController::class, 'approve'])->name('appointments.approve');
    Route::post('/appointments/{id}/cancel', [AppointmentController::class, 'cancel'])->name('appointments.cancel');
    Route::post('/appointments/{id}/complete', [AppointmentController::class, 'complete'])->name('appointments.complete');
    Route::get('/appointments/check-availability', [AppointmentController::class, 'checkAvailability'])->name('appointments.check-availability');
    
    // Customers
    Route::apiResource('customers', CustomerController::class);
    Route::get('/customers/search', [CustomerController::class, 'search'])->name('customers.search');
    
    // Services
    Route::apiResource('services', ServiceController::class);
    
    // Staff
    Route::apiResource('staff', StaffController::class)->only(['index', 'show', 'store', 'update', 'destroy']);
    Route::get('/staff/{id}/schedule', [StaffController::class, 'schedule'])->name('staff.schedule');
    
    // Rooms
    Route::apiResource('rooms', RoomController::class);
    
    // Invoices
    Route::get('/invoices', [\App\Http\Controllers\Api\V1\InvoiceController::class, 'index'])->name('invoices.index');
    Route::get('/invoices/{id}', [\App\Http\Controllers\Api\V1\InvoiceController::class, 'show'])->name('invoices.show');
    
    // Cashbox
    Route::get('/cashbox', [\App\Http\Controllers\Api\V1\CashboxController::class, 'index'])->name('cashbox.index');
    Route::post('/cashbox/income', [\App\Http\Controllers\Api\V1\CashboxController::class, 'storeIncome'])->name('cashbox.store-income');
    Route::post('/cashbox/expense', [\App\Http\Controllers\Api\V1\CashboxController::class, 'storeExpense'])->name('cashbox.store-expense');
    
    // Appointment Requests
    Route::get('/appointment-requests', [\App\Http\Controllers\Api\V1\AppointmentRequestController::class, 'index'])->name('appointment-requests.index');
    Route::get('/appointment-requests/{id}', [\App\Http\Controllers\Api\V1\AppointmentRequestController::class, 'show'])->name('appointment-requests.show');
    Route::post('/appointment-requests/{id}/approve', [\App\Http\Controllers\Api\V1\AppointmentRequestController::class, 'approve'])->name('appointment-requests.approve');
    
    // Notifications
    Route::get('/notifications', [\App\Http\Controllers\Api\V1\NotificationController::class, 'index'])->name('notifications.index');
});

