<?php

namespace App\Console;

use Illuminate\Console\Scheduling\Schedule;
use Illuminate\Foundation\Console\Kernel as ConsoleKernel;

class Kernel extends ConsoleKernel
{
    protected function schedule(Schedule $schedule): void
    {
        
        $schedule->command('appointments:send-reminders')
            ->hourly()
            ->withoutOverlapping()
            ->runInBackground();

        $schedule->command('notifications:cleanup')
            ->daily()
            ->at('02:00');

        $schedule->command('tokens:cleanup')
            ->daily()
            ->at('03:00');

        $schedule->command('licenses:check-expiration')
            ->daily()
            ->at('09:00');

        $schedule->command('sms:check-balance')
            ->daily()
            ->at('10:00');
    }

    protected function commands(): void
    {
        $this->load(__DIR__.'/Commands');

        require base_path('routes/console.php');
    }
}

