<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Service;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class BeautySalonPriceListController extends Controller
{
    public function index()
    {
        $user = Auth::user();
        
        if ($user->role !== 'güzellik_salonu') {
            abort(403);
        }
        
        $services = Service::orderBy('name')
            ->get();
        
        return view('admin.beauty-salon.price-list', compact('services'));
    }
}

