<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Customer;
use App\Models\Reservation;
use Illuminate\Http\Request;

class CustomerAccountController extends Controller
{
    public function index()
    {
        $user = auth()->user();
        $query = Customer::withCount('appointments');

        if ($user->role === 'randevucu') {
            $query->where('created_by', $user->id);
        }
        
        $customers = $query->orderBy('name')->paginate(20);

        return view('admin.accounting.customers', compact('customers'));
    }

    public function show($id)
    {
        $user = auth()->user();
        $query = Customer::query();

        if ($user->role === 'randevucu') {
            $query->where('created_by', $user->id);
        }
        
        $customer = $query->findOrFail($id);
        
        $reservationQuery = Reservation::where('customer_id', $id);

        if ($user->role === 'randevucu') {
            $reservationQuery->where('created_by', $user->id);
        }
        
        $appointments = $reservationQuery->orderBy('date', 'desc')->get();

        $totalAmount = $appointments->sum('total_price');
        $totalPaid = $appointments->sum('deposit_paid');
        $totalRemaining = $appointments->sum('remaining_amount');

        return view('admin.accounting.customer-detail', compact('customer', 'appointments', 'totalAmount', 'totalPaid', 'totalRemaining'));
    }
}

