<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Menu;
use App\Models\ActivityLog;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class MenuController extends Controller
{
    public function index()
    {
        $menus = Menu::orderBy('name')->get();
        return view('admin.settings.menus.index', compact('menus'));
    }

    public function create()
    {
        return view('admin.settings.menus.create');
    }

    public function store(Request $request)
    {
        $validated = $request->validate([
            'name' => 'required|string|max:255',
            'description' => 'nullable|string',
            'price' => 'required|numeric|min:0',
            'is_active' => 'boolean',
        ]);

        $menu = Menu::create($validated);

        ActivityLog::create([
            'user_id' => Auth::id(),
            'action' => 'create_menu',
            'description' => "Menü oluşturuldu: {$menu->name}",
            'ip_address' => $request->ip(),
        ]);

        return redirect()->route('admin.settings.menus.index')
            ->with('success', 'Menü oluşturuldu.');
    }

    public function edit($id)
    {
        $menu = Menu::findOrFail($id);
        return view('admin.settings.menus.edit', compact('menu'));
    }

    public function update(Request $request, $id)
    {
        $menu = Menu::findOrFail($id);

        $validated = $request->validate([
            'name' => 'required|string|max:255',
            'description' => 'nullable|string',
            'price' => 'required|numeric|min:0',
            'is_active' => 'boolean',
        ]);

        $menu->update($validated);

        ActivityLog::create([
            'user_id' => Auth::id(),
            'action' => 'update_menu',
            'description' => "Menü güncellendi: {$menu->name}",
            'ip_address' => $request->ip(),
        ]);

        return redirect()->route('admin.settings.menus.index')
            ->with('success', 'Menü güncellendi.');
    }

    public function destroy($id)
    {
        $menu = Menu::findOrFail($id);
        $name = $menu->name;
        $menu->delete();

        ActivityLog::create([
            'user_id' => Auth::id(),
            'action' => 'delete_menu',
            'description' => "Menü silindi: {$name}",
            'ip_address' => request()->ip(),
        ]);

        return redirect()->route('admin.settings.menus.index')
            ->with('success', 'Menü silindi.');
    }
}

