<?php

namespace App\Http\Controllers\Admin\Mobile;

use App\Http\Controllers\Controller;
use App\Models\Transaction;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class MobileAccountingController extends Controller
{
    public function index()
    {
        $user = Auth::user();
        
        $query = Transaction::with(['account', 'customer'])
            ->orderBy('date', 'desc')
            ->orderBy('created_at', 'desc');
        
        if ($user->role === 'randevucu' || $user->role === 'admin') {
            $query->where('created_by', $user->id);
        }
        
        $transactions = $query->get();
        
        return view('admin.mobile.accounting.index', compact('transactions'));
    }

    public function storeIncome(Request $request)
    {
        $validated = $request->validate([
            'account_id' => 'required|exists:accounts,id',
            'amount' => 'required|numeric|min:0',
            'date' => 'required|date',
            'description' => 'nullable|string',
        ]);

        Transaction::create([
            'account_id' => $validated['account_id'],
            'type' => 'income',
            'amount' => $validated['amount'],
            'date' => $validated['date'],
            'description' => $validated['description'] ?? null,
            'created_by' => Auth::id(),
        ]);

        return redirect()->back()->with('success', 'Gelir başarıyla kaydedildi.');
    }

    public function storeExpense(Request $request)
    {
        $validated = $request->validate([
            'account_id' => 'required|exists:accounts,id',
            'amount' => 'required|numeric|min:0',
            'date' => 'required|date',
            'description' => 'nullable|string',
        ]);

        Transaction::create([
            'account_id' => $validated['account_id'],
            'type' => 'expense',
            'amount' => $validated['amount'],
            'date' => $validated['date'],
            'description' => $validated['description'] ?? null,
            'created_by' => Auth::id(),
        ]);

        return redirect()->back()->with('success', 'Gider başarıyla kaydedildi.');
    }

    public function destroy($id)
    {
        $user = Auth::user();
        $query = Transaction::query();
        
        if ($user->role === 'randevucu' || $user->role === 'admin') {
            $query->where('created_by', $user->id);
        }
        
        $transaction = $query->findOrFail($id);
        $transaction->delete();

        return redirect()->back()->with('success', 'İşlem başarıyla silindi.');
    }
}

