<?php

namespace App\Http\Controllers\Admin\Mobile;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use App\Models\Reservation;
use App\Models\Transaction;
use App\Models\Account;
use App\Models\Customer;
use Carbon\Carbon;

class MobileDashboardController extends Controller
{
    public function index()
    {
        $user = Auth::user();

        $hour = Carbon::now()->setTimezone('Europe/Istanbul')->hour;
        if ($hour < 12) {
            $greeting = 'Günaydın';
        } elseif ($hour < 18) {
            $greeting = 'İyi günler';
        } else {
            $greeting = 'İyi akşamlar';
        }
        
        $today = Carbon::now()->setTimezone('Europe/Istanbul')->format('Y-m-d');
        $now = Carbon::now()->setTimezone('Europe/Istanbul');

        $todayIncome = 0;
        try {
            $cashAccount = Account::getCashAccount($user->id);
            $todayIncome = Transaction::where('account_id', $cashAccount->id)
                ->where('type', 'income')
                ->whereDate('date', $today)
                ->sum('amount');
        } catch (\Exception $e) {
            \Log::warning('Bugünkü gelir hesaplanamadı: ' . $e->getMessage());
        }

        $todayExpense = 0;
        try {
            $cashAccount = Account::getCashAccount($user->id);
            $todayExpense = Transaction::where('account_id', $cashAccount->id)
                ->where('type', 'expense')
                ->whereDate('date', $today)
                ->sum('amount');
        } catch (\Exception $e) {
            \Log::warning('Bugünkü gider hesaplanamadı: ' . $e->getMessage());
        }

        $todayAppointments = 0;
        try {
            $reservationQuery = Reservation::query();
            if ($user->role === 'randevucu' || $user->role === 'admin') {
                $reservationQuery->where('created_by', $user->id);
            }
            
            $dateColumn = 'date';
            if (\Schema::hasColumn('reservations', 'date')) {
                $dateColumn = 'date';
            } else {
                $dateColumn = 'appointment_date';
            }
            
            $todayAppointments = (clone $reservationQuery)
                ->whereDate($dateColumn, $today)
                ->where('status', '!=', 'cancelled')
                ->count();
        } catch (\Exception $e) {
            \Log::warning('Bugünkü randevular hesaplanamadı: ' . $e->getMessage());
        }

        $totalCustomers = 0;
        try {
            $totalCustomers = Customer::count();
        } catch (\Exception $e) {
            \Log::warning('Toplam müşteri hesaplanamadı: ' . $e->getMessage());
        }

        $monthlyRevenueAmount = 0;
        try {
            $cashAccount = Account::getCashAccount($user->id);
            $monthlyRevenueAmount = Transaction::where('account_id', $cashAccount->id)
                ->where('type', 'income')
                ->whereYear('date', $now->year)
                ->whereMonth('date', $now->month)
                ->sum('amount');
        } catch (\Exception $e) {
            \Log::warning('Aylık gelir hesaplanamadı: ' . $e->getMessage());
        }
        
        return view('admin.mobile.dashboard.index', compact(
            'greeting',
            'todayIncome',
            'todayExpense',
            'todayAppointments',
            'totalCustomers',
            'monthlyRevenueAmount',
            'now'
        ));
    }
}

