<?php

namespace App\Http\Controllers\Admin\Mobile;

use App\Http\Controllers\Controller;
use App\Models\Invoice;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class MobileInvoiceController extends Controller
{
    public function index()
    {
        $user = Auth::user();
        
        $query = Invoice::with(['customer', 'reservation'])
            ->orderBy('created_at', 'desc');
        
        if ($user->role === 'randevucu' || $user->role === 'admin') {
            $query->where('created_by', $user->id);
        }
        
        $invoices = $query->get();
        
        return view('admin.mobile.invoices.index', compact('invoices'));
    }

    public function show($id)
    {
        $user = Auth::user();
        $query = Invoice::with(['customer', 'reservation']);
        
        if ($user->role === 'randevucu' || $user->role === 'admin') {
            $query->where('created_by', $user->id);
        }
        
        $invoice = $query->findOrFail($id);
        
        return view('admin.mobile.invoices.show', compact('invoice'));
    }
}

