<?php

namespace App\Http\Controllers\Admin\Mobile;

use App\Http\Controllers\Controller;
use App\Models\Setting;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class MobileSettingsController extends Controller
{
    public function index()
    {
        $user = Auth::user();
        $settings = Setting::where('user_id', $user->id)->get()->keyBy('key');
        
        return view('admin.mobile.settings.index', compact('settings'));
    }

    public function update(Request $request)
    {
        $user = Auth::user();
        
        foreach ($request->except(['_token', '_method']) as $key => $value) {
            Setting::updateOrCreate(
                ['user_id' => $user->id, 'key' => $key],
                ['value' => $value]
            );
        }
        
        return redirect()->back()->with('success', 'Ayarlar başarıyla güncellendi.');
    }
}

