<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Package;
use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Carbon\Carbon;

class PackageSelectionController extends Controller
{
    public function index()
    {
        $user = Auth::user();
        
        if ($user->isSuperAdmin()) {
            return redirect()->route('admin.dashboard');
        }
        
        $packages = Package::where('is_active', true)
            ->orderBy('sort_order')
            ->orderBy('name')
            ->get();

        $freeCampaignActive = $user->free_access_ends_at && now()->lt($user->free_access_ends_at);

        return view('admin.packages.select', compact('packages', 'freeCampaignActive'));
    }

    public function purchase(Request $request, $packageId)
    {
        $user = Auth::user();
        
        if ($user->isSuperAdmin()) {
            return redirect()->route('admin.dashboard');
        }
        
        $package = Package::where('is_active', true)
            ->findOrFail($packageId);

        if ($user->free_access_ends_at && now()->lt($user->free_access_ends_at)) {
            return redirect()
                ->route('admin.dashboard')
                ->with('success', 'Ücretsiz kullanım süreniz aktif. Bu süre içinde paket satın almanız gerekmiyor.');
        }

        return redirect()->route('payment.checkout.package', $packageId);
    }
}
