<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\User;
use App\Models\Service;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;

class PersonelServiceController extends Controller
{
    public function index($personelId)
    {
        $user = Auth::user();
        
        if ($user->role !== 'güzellik_salonu') {
            abort(403);
        }
        
        $personel = User::where('id', $personelId)
            ->where('beauty_salon_id', $user->id)
            ->where('role', 'personel')
            ->firstOrFail();
        
        $services = Service::get();
        $personelServices = $personel->services()->pluck('services.id')->toArray();
        
        return view('admin.personel.services', compact('personel', 'services', 'personelServices'));
    }

    public function store(Request $request, $personelId)
    {
        $user = Auth::user();
        
        if ($user->role !== 'güzellik_salonu') {
            abort(403);
        }
        
        $personel = User::where('id', $personelId)
            ->where('beauty_salon_id', $user->id)
            ->where('role', 'personel')
            ->firstOrFail();
        
        $validated = $request->validate([
            'service_id' => 'required|exists:services,id',
        ]);
        
        if (!$personel->services()->where('services.id', $validated['service_id'])->exists()) {
            $personel->services()->attach($validated['service_id']);
        }
        
        return redirect()->back()
            ->with('success', 'Hizmet başarıyla eklendi.');
    }

    public function update(Request $request, $personelId, $id)
    {

        return $this->store($request, $personelId);
    }

    public function destroy($personelId, $id)
    {
        $user = Auth::user();
        
        if ($user->role !== 'güzellik_salonu') {
            abort(403);
        }
        
        $personel = User::where('id', $personelId)
            ->where('beauty_salon_id', $user->id)
            ->where('role', 'personel')
            ->firstOrFail();
        
        $personel->services()->detach($id);
        
        return redirect()->back()
            ->with('success', 'Hizmet başarıyla kaldırıldı.');
    }
}

