<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Process;
use Illuminate\Http\Request;

class ProcessController extends Controller
{
    public function index()
    {
        $processes = Process::orderBy('order')->get();
        return view('admin.settings.processes.index', compact('processes'));
    }

    public function create()
    {
        return view('admin.settings.processes.create');
    }

    public function store(Request $request)
    {
        $validated = $request->validate([
            'name' => 'required|string|max:255',
            'description' => 'nullable|string',
            'order' => 'nullable|integer',
        ]);

        Process::create($validated);

        return redirect()->route('admin.settings.processes.index')
            ->with('success', 'İşlem başarıyla oluşturuldu.');
    }

    public function edit($id)
    {
        $process = Process::findOrFail($id);
        return view('admin.settings.processes.edit', compact('process'));
    }

    public function update(Request $request, $id)
    {
        $process = Process::findOrFail($id);
        
        $validated = $request->validate([
            'name' => 'required|string|max:255',
            'description' => 'nullable|string',
            'order' => 'nullable|integer',
        ]);

        $process->update($validated);

        return redirect()->route('admin.settings.processes.index')
            ->with('success', 'İşlem başarıyla güncellendi.');
    }

    public function destroy($id)
    {
        $process = Process::findOrFail($id);
        $process->delete();

        return redirect()->route('admin.settings.processes.index')
            ->with('success', 'İşlem başarıyla silindi.');
    }
}

