<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

class ReferralController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        $user = auth()->user();
        
        if (!$user->isBeautySalon()) {
            abort(403, 'Bu sayfaya erişim yetkiniz yok.');
        }

        $referrals = \App\Models\Referral::where('beauty_salon_id', $user->id)
            ->with(['referrer', 'referred'])
            ->orderBy('created_at', 'desc')
            ->paginate(20);

        $totalReferrals = \App\Models\Referral::where('beauty_salon_id', $user->id)->count();
        $completedReferrals = \App\Models\Referral::where('beauty_salon_id', $user->id)
            ->where('status', 'completed')
            ->count();
        $totalRewards = \App\Models\ReferralRewardHistory::whereHas('referral', function($query) use ($user) {
            $query->where('beauty_salon_id', $user->id);
        })->sum('reward_amount') ?? 0.0;

        return view('admin.referrals.index', compact('referrals', 'totalReferrals', 'completedReferrals', 'totalRewards'));
    }

    /**
     * Display referral rewards.
     */
    public function rewards()
    {
        $user = auth()->user();
        
        if (!$user->isBeautySalon()) {
            abort(403, 'Bu sayfaya erişim yetkiniz yok.');
        }

        $rewards = \App\Models\ReferralReward::where('beauty_salon_id', $user->id)
            ->orderBy('created_at', 'desc')
            ->get();

        return view('admin.referrals.rewards', compact('rewards'));
    }

    /**
     * Display referral history.
     */
    public function history()
    {
        $user = auth()->user();
        
        if (!$user->isBeautySalon()) {
            abort(403, 'Bu sayfaya erişim yetkiniz yok.');
        }

        $rewardHistory = \App\Models\ReferralRewardHistory::whereHas('referral', function($query) use ($user) {
            $query->where('beauty_salon_id', $user->id);
        })
        ->with(['customer', 'referral'])
        ->orderBy('created_at', 'desc')
        ->paginate(20);

        return view('admin.referrals.history', compact('rewardHistory'));
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(string $id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, string $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(string $id)
    {
        //
    }
}
