<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\Reservation;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class AppointmentApiController extends Controller
{
    public function index(Request $request)
    {
        $user = Auth::user();
        
        $query = Reservation::with(['customer', 'personel', 'room', 'services'])
            ->where('beauty_salon_id', $user->id);

        if ($request->has('status')) {
            $query->where('status', $request->status);
        }

        $appointments = $query->orderBy('date', 'desc')
            ->orderBy('start_time', 'desc')
            ->paginate(15);

        return response()->json([
            'success' => true,
            'data' => $appointments,
        ]);
    }

    public function store(Request $request)
    {
        // ReservationApiController'daki store metodunu kullan
        $reservationController = app(\App\Http\Controllers\Api\ReservationApiController::class);
        return $reservationController->store($request);
    }

    public function show($id)
    {
        $user = Auth::user();
        
        $appointment = Reservation::with(['customer', 'personel', 'room', 'services'])
            ->where('beauty_salon_id', $user->id)
            ->findOrFail($id);

        return response()->json([
            'success' => true,
            'data' => $appointment,
        ]);
    }

    public function update(Request $request, $id)
    {
        $user = Auth::user();
        
        $appointment = Reservation::where('beauty_salon_id', $user->id)
            ->findOrFail($id);

        $validated = $request->validate([
            'date' => 'sometimes|date',
            'start_time' => 'sometimes',
            'status' => 'sometimes|in:confirmed,cancelled,completed',
            'notes' => 'nullable|string',
        ]);

        $appointment->update($validated);

        return response()->json([
            'success' => true,
            'message' => 'Randevu güncellendi',
            'data' => $appointment,
        ]);
    }

    public function destroy($id)
    {
        $user = Auth::user();
        
        $appointment = Reservation::where('beauty_salon_id', $user->id)
            ->findOrFail($id);

        $appointment->delete();

        return response()->json([
            'success' => true,
            'message' => 'Randevu silindi',
        ]);
    }
}

