<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\Contract;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class ContractApiController extends Controller
{
    public function index(Request $request)
    {
        $user = Auth::user();
        
        $query = Contract::query();

        if ($user->role === 'güzellik_salonu') {
            $query->where('beauty_salon_id', $user->id);
        } elseif ($user->role === 'randevucu' || $user->role === 'admin') {
            $query->where('created_by', $user->id);
        }

        $contracts = $query->orderBy('created_at', 'desc')
            ->paginate(15);

        return response()->json([
            'success' => true,
            'data' => $contracts,
        ]);
    }

    public function show($id)
    {
        $user = Auth::user();
        
        $query = Contract::query();

        if ($user->role === 'güzellik_salonu') {
            $query->where('beauty_salon_id', $user->id);
        } elseif ($user->role === 'randevucu' || $user->role === 'admin') {
            $query->where('created_by', $user->id);
        }

        $contract = $query->findOrFail($id);

        return response()->json([
            'success' => true,
            'data' => $contract,
        ]);
    }
}

