<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\Reservation;
use App\Models\Customer;
use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Carbon\Carbon;

class DashboardApiController extends Controller
{
    public function index(Request $request): JsonResponse
    {
        $user = $request->user();
        
        $today = Carbon::today();

        $reservationQuery = Reservation::query();
        
        if ($user->role === 'personel') {
            $reservationQuery->where('personel_id', $user->id);
        } elseif ($user->role === 'beauty_salon') {
            $reservationQuery->where('beauty_salon_id', $user->beauty_salon_id);
        } elseif ($user->role === 'randevucu') {
            $reservationQuery->where('company_id', $user->company_id);
        }

        $todayAppointments = (clone $reservationQuery)
            ->whereDate('date', $today)
            ->where('status', '!=', 'iptal')
            ->count();

        $totalAppointments = (clone $reservationQuery)
            ->where('status', '!=', 'iptal')
            ->count();

        $customerQuery = Customer::query();
        if ($user->role === 'beauty_salon') {
            $customerQuery->where('beauty_salon_id', $user->beauty_salon_id);
        } elseif ($user->role === 'randevucu') {
            $customerQuery->where('company_id', $user->company_id);
        }
        $totalCustomers = $customerQuery->count();

        $revenueQuery = (clone $reservationQuery)
            ->where('status', 'tamamlandi')
            ->whereMonth('date', $today->month)
            ->whereYear('date', $today->year);
        
        $revenue = $revenueQuery->sum('total_price') ?? 0.0;

        return response()->json([
            'success' => true,
            'data' => [
                'today_appointments' => $todayAppointments,
                'total_appointments' => $totalAppointments,
                'total_customers' => $totalCustomers,
                'revenue' => (float) $revenue,
            ],
        ]);
    }
}

