<?php

namespace App\Http\Controllers\Api;

use App\Helpers\DistrictHelper;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class DistrictController extends Controller
{
    public function index(Request $request)
    {
        $city = $request->get('city');
        
        if (!$city) {
            return response()->json([]);
        }
        
        // Önce veritabanından dene
        $dbDistricts = DB::table('districts')
            ->where('city', $city)
            ->orderBy('name')
            ->get(['name']);
        
        if ($dbDistricts->isNotEmpty()) {
            return response()->json($dbDistricts);
        }
        
        // Veritabanı boşsa helper'dan tüm ilçeleri kullan
        $allDistricts = DistrictHelper::getAllDistricts();
        $cityDistricts = $allDistricts[$city] ?? [];
        $formatted = array_map(fn ($name) => (object) ['name' => $name], $cityDistricts);
        
        return response()->json($formatted);
    }
}
