<?php

namespace App\Http\Controllers\Api\Mobile;

use App\Http\Controllers\Controller;
use App\Services\PermissionService;
use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;

class PermissionController extends Controller
{
    private PermissionService $permissionService;

    public function __construct(PermissionService $permissionService)
    {
        $this->permissionService = $permissionService;
    }

    public function index(Request $request): JsonResponse
    {
        $user = $request->user();

        if (!$user->is_active) {
            return response()->json([
                'success' => false,
                'message' => 'Hesabınız askıya alınmış',
                'code' => 'ACCOUNT_SUSPENDED',
            ], 403);
        }

        if ($user->license_expires_at && $user->license_expires_at->isPast()) {
            return response()->json([
                'success' => false,
                'message' => 'Lisans süreniz dolmuş',
                'code' => 'LICENSE_EXPIRED',
            ], 403);
        }

        $permissions = $this->permissionService->getUserPermissions($user);

        return response()->json([
            'success' => true,
            'data' => $permissions,
        ]);
    }
}

