<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class SalonApiController extends Controller
{
    public function index(Request $request)
    {
        $user = Auth::user();
        
        $query = User::where('role', 'güzellik_salonu')
            ->where('is_active', true);

        if ($request->has('search')) {
            $search = $request->search;
            $query->where(function($q) use ($search) {
                $q->where('name', 'like', "%{$search}%")
                  ->orWhere('salon_name', 'like', "%{$search}%");
            });
        }

        $salons = $query->select('id', 'name', 'salon_name', 'salon_slug', 'salon_address', 'phone')
            ->paginate(15);

        return response()->json([
            'success' => true,
            'data' => $salons,
        ]);
    }
}

