<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Log;

class SmsWebhookController extends Controller
{
    public function handle(Request $request, $provider)
    {
        try {
            Log::info('SMS webhook received', [
                'provider' => $provider,
                'data' => $request->all(),
            ]);

            // SMS webhook işlemleri burada yapılabilir
            // Örneğin: SMS durum güncellemeleri, teslimat raporları, vb.

            return response()->json([
                'success' => true,
                'message' => 'Webhook received',
            ], 200);
        } catch (\Exception $e) {
            Log::error('SMS webhook error: ' . $e->getMessage(), [
                'provider' => $provider,
                'trace' => $e->getTraceAsString(),
            ]);

            return response()->json([
                'success' => false,
                'message' => 'Error processing webhook',
            ], 500);
        }
    }
}

