<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

class PageController extends Controller
{
    public function about()
    {
        return view('pages.about');
    }

    public function contact()
    {
        return view('pages.contact');
    }

    public function pricing()
    {
        return view('pages.pricing');
    }

    public function kvkk()
    {
        try {
            $settings = \App\Models\Setting::where('group', 'general')->pluck('value', 'key')->toArray();
        } catch (\Exception $e) {
            $settings = [];
        }
        return view('pages.kvkk', compact('settings'));
    }

    public function cookies()
    {
        try {
            $settings = \App\Models\Setting::where('group', 'general')->pluck('value', 'key')->toArray();
        } catch (\Exception $e) {
            $settings = [];
        }
        return view('pages.cookies', compact('settings'));
    }

    public function faq()
    {
        return view('pages.faq');
    }


    public function privacy()
    {
        try {
            $settings = \App\Models\Setting::where('group', 'general')->pluck('value', 'key')->toArray();
        } catch (\Exception $e) {
            $settings = [];
        }
        return view('pages.privacy', compact('settings'));
    }

    public function terms()
    {
        try {
            $settings = \App\Models\Setting::where('group', 'general')->pluck('value', 'key')->toArray();
        } catch (\Exception $e) {
            $settings = [];
        }
        return view('pages.terms', compact('settings'));
    }

    public function purchaseAgreement()
    {
        try {
            $settings = \App\Models\Setting::where('group', 'general')->pluck('value', 'key')->toArray();
        } catch (\Exception $e) {
            $settings = [];
        }
        return view('pages.purchase-agreement', compact('settings'));
    }

    public function architecture()
    {
        return view('pages.architecture');
    }
}
