<?php

namespace App\Http\Controllers\Public;

use App\Http\Controllers\Controller;
use App\Models\User;
use App\Models\Customer;
use App\Models\CustomerLoyalty;
use App\Models\Reservation;
use Illuminate\Http\Request;

class LoyaltyCardController extends Controller
{
    public function show($slug, $phone)
    {
        // Salon'u bul - önce slug ile, yoksa isim ile dene
        $salon = User::where(function($query) use ($slug) {
                $query->where('salon_slug', $slug)
                      ->orWhere('salon_short_name', $slug)
                      ->orWhereRaw('LOWER(REPLACE(salon_name, " ", "-")) = ?', [strtolower($slug)]);
            })
            ->where('role', 'güzellik_salonu')
            ->firstOrFail();

        // Telefon numarasını normalize et (0 ve + işaretlerini kaldır, sadece rakamlar)
        $normalizedPhone = preg_replace('/[^0-9]/', '', $phone);
        
        // Müşteriyi bul
        $customer = Customer::where('beauty_salon_id', $salon->id)
            ->where(function($query) use ($normalizedPhone, $phone) {
                $query->whereRaw('REPLACE(REPLACE(REPLACE(phone, "+", ""), " ", ""), "-", "") = ?', [$normalizedPhone])
                      ->orWhere('phone', 'like', '%' . $normalizedPhone . '%')
                      ->orWhere('phone', $phone);
            })
            ->first();

        if (!$customer) {
            abort(404, 'Müşteri bulunamadı.');
        }

        // Loyalty kart aktif mi kontrol et
        if (!$customer->loyalty_card_enabled) {
            abort(404, 'Loyalty kart aktif değil.');
        }

        // Müşterinin loyalty bilgilerini al
        $customerLoyalty = CustomerLoyalty::where('customer_id', $customer->id)
            ->where('beauty_salon_id', $salon->id)
            ->with('loyaltyTier')
            ->first();

        // Randevu sayısını hesapla
        $completedReservations = Reservation::where('customer_id', $customer->id)
            ->where('beauty_salon_id', $salon->id)
            ->where('status', 'completed')
            ->count();

        // Toplam puan
        $totalPoints = $customerLoyalty ? $customerLoyalty->total_points : 0;
        
        // Mevcut seviye
        $currentTier = $customerLoyalty && $customerLoyalty->loyaltyTier 
            ? $customerLoyalty->loyaltyTier 
            : null;

        // Sonraki seviye için gereken ziyaret sayısı
        $nextTier = null;
        if ($currentTier) {
            $nextTier = \App\Models\LoyaltyTier::where('beauty_salon_id', $salon->id)
                ->where('level', '>', $currentTier->level)
                ->where('is_active', true)
                ->orderBy('level')
                ->first();
        } else {
            // İlk seviyeyi al
            $nextTier = \App\Models\LoyaltyTier::where('beauty_salon_id', $salon->id)
                ->where('is_active', true)
                ->orderBy('level')
                ->first();
        }

        return view('public.loyalty-card.show', compact(
            'salon',
            'customer',
            'customerLoyalty',
            'completedReservations',
            'totalPoints',
            'currentTier',
            'nextTier'
        ));
    }
}
