<?php

namespace App\Http\Controllers\Public;

use App\Http\Controllers\Controller;
use App\Models\User;
use App\Models\SalonRating;
use Illuminate\Http\Request;

class SalonListController extends Controller
{
    public function index(Request $request)
    {
        // Filtreleme parametreleri
        $search = $request->get('search', '');
        $city = $request->get('city', '');
        $district = $request->get('district', '');
        
        // Tüm aktif güzellik salonlarını al
        $query = User::where('role', 'güzellik_salonu')
            ->where('is_active', true)
            ->whereNotNull('salon_slug');
        
        // İsim ile filtreleme
        if (!empty($search)) {
            $query->where(function($q) use ($search) {
                $q->where('salon_name', 'like', "%{$search}%")
                  ->orWhere('name', 'like', "%{$search}%");
            });
        }
        
        // İl ile filtreleme
        if (!empty($city)) {
            $query->where('salon_city', $city);
        }
        
        // İlçe ile filtreleme
        if (!empty($district)) {
            $query->where('salon_district', $district);
        }
        
        // Salonları al ve rating bilgilerini ekle
        $salons = $query->get()->map(function($salon) {
            $salon->average_rating = SalonRating::getAverageRating($salon->id);
            $salon->rating_count = SalonRating::getRatingCount($salon->id);
            return $salon;
        });
        
        // Rating'e göre sırala (yüksekten düşüğe)
        $salons = $salons->sortByDesc(function($salon) {
            return $salon->average_rating;
        })->values();
        
        // İlleri al (benzersiz)
        $cities = User::where('role', 'güzellik_salonu')
            ->where('is_active', true)
            ->whereNotNull('salon_city')
            ->whereNotNull('salon_slug')
            ->distinct()
            ->orderBy('salon_city')
            ->pluck('salon_city')
            ->filter()
            ->values();
        
        // İlçeleri al (seçili ile göre veya tümü)
        $districts = User::where('role', 'güzellik_salonu')
            ->where('is_active', true)
            ->whereNotNull('salon_district')
            ->whereNotNull('salon_slug');
        
        if (!empty($city)) {
            $districts->where('salon_city', $city);
        }
        
        $districts = $districts->distinct()
            ->orderBy('salon_district')
            ->pluck('salon_district')
            ->filter()
            ->values();
        
        return view('public.salon-list', compact('salons', 'cities', 'districts', 'search', 'city', 'district'));
    }
}

