<?php

namespace App\Http\Controllers\Public;

use App\Http\Controllers\Controller;
use App\Models\User;
use App\Models\SalonRating;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;

class SalonRatingController extends Controller
{
    public function show($slug, $token)
    {
        
        $salon = User::where('salon_slug', $slug)
            ->where('role', 'güzellik_salonu')
            ->firstOrFail();

        $rating = SalonRating::where('token', $token)
            ->where('salon_id', $salon->id)
            ->firstOrFail();

        if (!$rating->isValid()) {
            return view('public.salon.rating-expired', compact('salon'));
        }
        
        return view('public.salon.rating', compact('salon', 'rating'));
    }
    
    public function store(Request $request, $slug, $token)
    {
        $validator = Validator::make($request->all(), [
            'rating' => 'required|integer|min:1|max:5',
            'comment' => 'nullable|string|max:1000',
        ], [
            'rating.required' => 'Lütfen puan seçin.',
            'rating.integer' => 'Puan geçerli bir sayı olmalıdır.',
            'rating.min' => 'Puan en az 1 olmalıdır.',
            'rating.max' => 'Puan en fazla 5 olmalıdır.',
            'comment.max' => 'Yorum en fazla 1000 karakter olabilir.',
        ]);
        
        if ($validator->fails()) {
            return back()->withErrors($validator)->withInput();
        }

        $salon = User::where('salon_slug', $slug)
            ->where('role', 'güzellik_salonu')
            ->firstOrFail();

        $rating = SalonRating::where('token', $token)
            ->where('salon_id', $salon->id)
            ->firstOrFail();

        if (!$rating->isValid()) {
            return back()->with('error', 'Bu link artık geçersiz veya kullanılmış.');
        }

        $rating->update([
            'rating' => $request->rating,
            'comment' => $request->comment,
            'is_used' => true,
        ]);
        
        return redirect()->route('public.salon.show', ['slug' => $slug])
            ->with('success', 'Değerlendirmeniz için teşekkür ederiz!');
    }
}
