<?php

namespace App\Http\Controllers\Public;

use App\Http\Controllers\Controller;
use App\Models\User;
use Illuminate\Http\Request;

class SalonSearchController extends Controller
{
    public function search(Request $request)
    {
        try {
            $city = $request->get('city');
            $district = $request->get('district');
            
            if (!$city) {
                return response()->json(['salons' => [], 'error' => 'İl seçimi zorunludur.'], 400);
            }
            
            $query = User::where('role', 'güzellik_salonu')
                ->where('is_active', true)
                ->where('salon_city', $city);
            
            if ($district) {
                $query->where('salon_district', $district);
            }
            
            $salons = $query->orderBy('salon_name')
                ->get()
                ->map(function($user) {
                    return [
                        'id' => $user->id,
                        'name' => $user->salon_name ?? $user->name,
                        'address' => $user->salon_address ?? '',
                        'phone' => $user->salon_phone ?? $user->phone ?? '',
                        'city' => $user->salon_city ?? '',
                        'district' => $user->salon_district ?? '',
                        'slug' => $user->salon_slug ?? null,
                        'profile_image' => $user->salon_profile_image ?? null,
                    ];
                });
            
            return response()->json(['salons' => $salons]);
        } catch (\Exception $e) {
            return response()->json([
                'salons' => [],
                'error' => 'Arama sırasında bir hata oluştu: ' . $e->getMessage()
            ], 500);
        }
    }
}
