<?php

namespace App\Http\Controllers\Public;

use App\Http\Controllers\Controller;
use App\Models\User;
use Illuminate\Http\Request;

class ShortUrlController extends Controller
{
    
    public static function isReservedRoute($slug)
    {
        $reservedRoutes = [
            'admin', 'api', 'login', 'register', 'logout', 'password', 'email',
            'salon', 'randevu-talep', 'hakkimizda', 'iletisim', 'fiyatlandirma',
            'kayit', 'gizlilik-politikasi', 'kullanim-sartlari', 'kvkk',
            'cerez-politikasi', 'sss', 'ozellikler', 'indir', 'sitemap.xml',
            'public', 'storage', 'assets', 'css', 'js', 'images', 'fonts',
            'vendor', 'bootstrap', 'jquery', 'ajax', 'json', 'xml', 'personel',
            'sozlesme', 'fatura', 'randevu', 'musteriler', 'hesaplar', 'kasa',
            'raporlar', 'kampanyalar', 'bildirimler', 'ayarlar', 'guzellik-salonu',
            'randevular', 'hizmetler', 'odalar', 'profil', 'mobile', 'app'
        ];
        
        return in_array(strtolower($slug), $reservedRoutes);
    }

    public static function isUrlTaken($url, $excludeUserId = null)
    {
        
        if (self::isReservedRoute($url)) {
            return true;
        }

        $query = \App\Models\User::where('short_url', $url)
            ->where('role', 'güzellik_salonu');
        
        if ($excludeUserId) {
            $query->where('id', '!=', $excludeUserId);
        }
        
        if ($query->exists()) {
            return true;
        }

        $query = \App\Models\User::where('salon_slug', $url)
            ->where('role', 'güzellik_salonu');
        
        if ($excludeUserId) {
            $query->where('id', '!=', $excludeUserId);
        }
        
        return $query->exists();
    }

    public function redirect($shortUrl)
    {
        
        if ($this->isReservedRoute($shortUrl)) {
            abort(404);
        }

        $salon = User::where('short_url', $shortUrl)
            ->where('role', 'güzellik_salonu')
            ->first();
        
        if (!$salon) {
            abort(404);
        }

        if ($salon->salon_slug) {
            return redirect()->route('public.salon.show', ['slug' => $salon->salon_slug], 301);
        }
        
        abort(404);
    }
}

