<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Log;

class SmsCallbackController extends Controller
{
    public function handle(Request $request)
    {
        try {
            Log::info('SMS callback received', [
                'data' => $request->all(),
            ]);

            // SMS callback işlemleri burada yapılabilir
            // Örneğin: Gelen SMS'leri işle, müşteri mesajlarını kaydet, vb.

            return response()->json([
                'success' => true,
                'message' => 'SMS callback received',
            ], 200);
        } catch (\Exception $e) {
            Log::error('SMS callback error: ' . $e->getMessage(), [
                'trace' => $e->getTraceAsString(),
            ]);

            return response()->json([
                'success' => false,
                'message' => 'Error processing SMS callback',
            ], 500);
        }
    }
}

