<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;

class CheckBeautySalon
{
    
    public function handle(Request $request, Closure $next): Response
    {
        $user = $request->user();

        if (!$user) {
            return redirect()->route('login');
        }

        if (!$user->isBeautySalon()) {
            abort(403, 'Bu sayfaya erişim yetkiniz yok. Sadece güzellik salonu kullanıcıları bu sayfaya erişebilir.');
        }
        
        return $next($request);
    }
}

