<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;

class EnsurePersonel
{
    public function handle(Request $request, Closure $next): Response
    {
        $user = $request->user();
        
        if (!$user || $user->role !== 'personel') {
            return response()->json([
                'success' => false,
                'message' => 'Bu işlem için personel yetkisi gereklidir',
                'code' => 'PERSONEL_ONLY',
            ], 403);
        }

        return $next($request);
    }
}
