<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;

class MobileOnly
{
    
    public function handle(Request $request, Closure $next): Response
    {
        
        $userAgent = $request->header('User-Agent', '');

        $isFlutterWebView = str_contains(strtolower($userAgent), 'flutter') || 
                           str_contains(strtolower($userAgent), 'inappwebview') ||
                           $request->header('X-Flutter-App', false);

        $isMobile = $this->isMobileDevice($userAgent);

        if (!$isFlutterWebView && !$isMobile) {
            
            return redirect('/')->with('error', 'Bu sayfaya sadece mobil uygulamadan erişebilirsiniz.');
        }
        
        return $next($request);
    }

    private function isMobileDevice(string $userAgent): bool
    {
        $mobileKeywords = [
            'mobile', 'android', 'iphone', 'ipad', 'ipod', 
            'blackberry', 'windows phone', 'opera mini'
        ];
        
        $userAgentLower = strtolower($userAgent);
        
        foreach ($mobileKeywords as $keyword) {
            if (str_contains($userAgentLower, $keyword)) {
                return true;
            }
        }
        
        return false;
    }
}

