<?php

namespace App\Http\Resources\Api;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class UserResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return [
            'id' => $this->id,
            'name' => $this->name,
            'email' => $this->email,
            'phone' => $this->phone,
            'role' => $this->role,
            'is_beauty_salon' => $this->isBeautySalon(),
            'is_personel' => $this->isPersonel(),
            'salon_name' => $this->salon_name,
            'salon_address' => $this->salon_address,
            'salon_city' => $this->salon_city,
            'salon_district' => $this->salon_district,
            'profile_image' => $this->profile_image ? asset('storage/' . $this->profile_image) : null,
            'created_at' => $this->created_at?->toISOString(),
            'updated_at' => $this->updated_at?->toISOString(),
        ];
    }
}

