<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class AppointmentRequest extends Model
{
    use HasFactory;

    protected $fillable = [
        'beauty_salon_id',
        'service_id',
        'service_ids',
        'customer_id',
        'name',
        'surname',
        'age',
        'phone',
        'phone_verified',
        'otp_code',
        'otp_expires_at',
        'status',
        'appointment_date',
        'appointment_time',
        'personel_id',
        'room_id',
        'reservation_id',
        'notes',
        'recurring_data',
        'referral_code',
    ];

    protected $casts = [
        'phone_verified' => 'boolean',
        'otp_expires_at' => 'datetime',
        'appointment_date' => 'date',
        'age' => 'integer',
        'recurring_data' => 'array',
        'service_ids' => 'array',
    ];

    public function getAppointmentTimeFormattedAttribute()
    {
        return $this->appointment_time ? date('H:i', strtotime($this->appointment_time)) : null;
    }

    public function beautySalon()
    {
        return $this->belongsTo(User::class, 'beauty_salon_id');
    }

    public function service()
    {
        return $this->belongsTo(Service::class);
    }

    public function customer()
    {
        return $this->belongsTo(Customer::class);
    }

    public function personel()
    {
        return $this->belongsTo(User::class, 'personel_id');
    }

    public function room()
    {
        return $this->belongsTo(Room::class);
    }

    public function reservation()
    {
        return $this->belongsTo(Reservation::class);
    }
}

