<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Str;

class Branch extends Model
{
    use HasFactory;

    protected $fillable = [
        'parent_salon_id',
        'branch_manager_id',
        'name',
        'slug',
        'phone',
        'address',
        'city',
        'district',
        'status',
        'revenue_share_percentage',
        'can_create_campaigns',
        'settings',
    ];

    protected $casts = [
        'revenue_share_percentage' => 'decimal:2',
        'can_create_campaigns' => 'boolean',
        'settings' => 'array',
    ];

    protected static function boot()
    {
        parent::boot();

        static::creating(function ($branch) {
            if (empty($branch->slug)) {
                $branch->slug = Str::slug($branch->name);
            }
        });
    }

    public function parentSalon()
    {
        return $this->belongsTo(User::class, 'parent_salon_id');
    }

    public function branchManager()
    {
        return $this->belongsTo(User::class, 'branch_manager_id');
    }

    public function staff()
    {
        return $this->hasMany(BranchStaff::class);
    }

    public function revenueSharing()
    {
        return $this->hasMany(BranchRevenueSharing::class);
    }
}
