<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Campaign extends Model
{
    use HasFactory;

    protected $fillable = [
        'beauty_salon_id',
        'name',
        'description',
        'type',
        'status',
        'start_date',
        'end_date',
        'budget',
        'budget_used',
        'max_redemptions',
        'redemptions_count',
        'discount_percentage',
        'discount_amount',
        'target_segments',
        'target_services',
        'auto_stop_on_loss',
        'min_roi',
    ];

    protected $casts = [
        'start_date' => 'date',
        'end_date' => 'date',
        'budget' => 'decimal:2',
        'budget_used' => 'decimal:2',
        'discount_percentage' => 'decimal:2',
        'discount_amount' => 'decimal:2',
        'min_roi' => 'decimal:2',
        'target_segments' => 'array',
        'target_services' => 'array',
        'auto_stop_on_loss' => 'boolean',
    ];

    public function beautySalon()
    {
        return $this->belongsTo(User::class, 'beauty_salon_id');
    }

    public function rules()
    {
        return $this->hasMany(CampaignRule::class);
    }

    public function performance()
    {
        return $this->hasMany(CampaignPerformance::class);
    }

    public function redemptions()
    {
        return $this->hasMany(CampaignRedemption::class);
    }
}
