<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Customer extends Model
{
    use HasFactory;

    protected $fillable = [
        'name',
        'phone',
        'email',
        'address',
        'notes',
        'balance',
        'loyalty_card_enabled',
        'created_by',
        'beauty_salon_id',
    ];

    protected $casts = [
        'balance' => 'decimal:2',
        'loyalty_card_enabled' => 'boolean',
    ];

    public function creator()
    {
        return $this->belongsTo(User::class, 'created_by');
    }

    public function reservations()
    {
        return $this->hasMany(Reservation::class);
    }

    public function beautySalon()
    {
        return $this->belongsTo(User::class, 'beauty_salon_id');
    }

    public function getInitialsAttribute(): string
    {
        $name = trim($this->name ?? '');
        if (empty($name)) {
            return '?';
        }
        
        $nameParts = explode(' ', $name, 2);
        
        $firstInitial = mb_substr($nameParts[0], 0, 1, 'UTF-8');
        $lastInitial = '';
        
        // Eğer soy isim varsa, soy ismin ilk harfini al
        if (isset($nameParts[1]) && !empty(trim($nameParts[1]))) {
            $lastInitial = mb_substr(trim($nameParts[1]), 0, 1, 'UTF-8');
        }
        
        $initials = mb_strtoupper($firstInitial . $lastInitial, 'UTF-8');
        
        return $initials ?: mb_strtoupper($firstInitial, 'UTF-8');
    }

    public function getAvatarColorAttribute(): string
    {
        $colors = [
            '#ec4899', '#3b82f6', '#8b5cf6', '#f59e0b', '#10b981',
            '#ef4444', '#06b6d4', '#f97316', '#84cc16', '#6366f1',
            '#a855f7', '#14b8a6', '#f43f5e', '#8b5a3c', '#64748b'
        ];
        
        // Eğer avatar_color kolonu varsa ve değer atanmışsa onu kullan
        if (isset($this->attributes['avatar_color']) && !empty($this->attributes['avatar_color'])) {
            return $this->attributes['avatar_color'];
        }
        
        // Yoksa isim ve telefon numarasına göre bir renk seç
        $seed = $this->name . ($this->phone ?? $this->id);
        $index = crc32($seed) % count($colors);
        return $colors[$index];
    }
}

