<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class CustomerClvScore extends Model
{
    use HasFactory;

    protected $fillable = [
        'customer_id',
        'beauty_salon_id',
        'segment_id',
        'clv_score',
        'average_order_value',
        'purchase_frequency',
        'total_visits',
        'total_spend',
        'days_since_first_visit',
        'days_since_last_visit',
        'churn_risk_score',
        'churn_risk_level',
        'is_vip',
        'last_calculated_at',
    ];

    protected $casts = [
        'clv_score' => 'decimal:2',
        'average_order_value' => 'decimal:2',
        'purchase_frequency' => 'decimal:2',
        'total_spend' => 'decimal:2',
        'churn_risk_score' => 'decimal:2',
        'is_vip' => 'boolean',
        'last_calculated_at' => 'datetime',
    ];

    public function customer()
    {
        return $this->belongsTo(Customer::class);
    }

    public function beautySalon()
    {
        return $this->belongsTo(User::class, 'beauty_salon_id');
    }

    public function segment()
    {
        return $this->belongsTo(CustomerSegment::class);
    }

    public function calculationHistory()
    {
        return $this->hasMany(ClvCalculationHistory::class, 'customer_clv_score_id');
    }
}
