<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class CustomerLoyalty extends Model
{
    use HasFactory;

    protected $table = 'customer_loyalty';

    protected $fillable = [
        'customer_id',
        'beauty_salon_id',
        'loyalty_tier_id',
        'total_points',
        'total_visits',
        'total_spend',
        'points_used',
        'points_available',
        'last_visit_at',
        'tier_upgraded_at',
    ];

    protected $casts = [
        'total_points' => 'decimal:2',
        'total_spend' => 'decimal:2',
        'points_used' => 'decimal:2',
        'points_available' => 'decimal:2',
        'last_visit_at' => 'datetime',
        'tier_upgraded_at' => 'datetime',
    ];

    public function customer()
    {
        return $this->belongsTo(Customer::class);
    }

    public function beautySalon()
    {
        return $this->belongsTo(User::class, 'beauty_salon_id');
    }

    public function loyaltyTier()
    {
        return $this->belongsTo(LoyaltyTier::class);
    }

    public function pointsHistory()
    {
        return $this->hasMany(LoyaltyPointsHistory::class);
    }
}
