<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class CustomerMembership extends Model
{
    use HasFactory;

    protected $fillable = [
        'customer_id',
        'beauty_salon_id',
        'membership_package_id',
        'status',
        'start_date',
        'end_date',
        'next_renewal_date',
        'services_used',
        'services_remaining',
        'amount_used',
        'amount_remaining',
        'auto_renew',
        'paused_at',
        'cancelled_at',
        'cancellation_reason',
    ];

    protected $casts = [
        'start_date' => 'date',
        'end_date' => 'date',
        'next_renewal_date' => 'date',
        'paused_at' => 'datetime',
        'cancelled_at' => 'datetime',
        'amount_used' => 'decimal:2',
        'amount_remaining' => 'decimal:2',
        'auto_renew' => 'boolean',
    ];

    public function customer()
    {
        return $this->belongsTo(Customer::class);
    }

    public function beautySalon()
    {
        return $this->belongsTo(User::class, 'beauty_salon_id');
    }

    public function membershipPackage()
    {
        return $this->belongsTo(MembershipPackage::class);
    }

    public function usageHistory()
    {
        return $this->hasMany(MembershipUsageHistory::class);
    }

    public function payments()
    {
        return $this->hasMany(MembershipPayment::class);
    }
}
