<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class CustomerMessage extends Model
{
    use HasFactory;

    protected $fillable = [
        'beauty_salon_id',
        'message_type',
        'template_key',
        'message_content',
        'customer_ids',
        'total_sent',
        'total_failed',
        'send_method',
        'sent_at',
    ];

    protected $casts = [
        'customer_ids' => 'array',
        'total_sent' => 'integer',
        'total_failed' => 'integer',
        'sent_at' => 'datetime',
    ];

    public function beautySalon()
    {
        return $this->belongsTo(User::class, 'beauty_salon_id');
    }

    public function customers()
    {
        if (!$this->customer_ids) {
            return collect();
        }
        return Customer::whereIn('id', $this->customer_ids)->get();
    }
}
