<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Str;

class CustomerSegment extends Model
{
    use HasFactory;

    protected $fillable = [
        'beauty_salon_id',
        'name',
        'slug',
        'description',
        'min_clv',
        'max_clv',
        'min_visits',
        'max_visits',
        'days_since_last_visit',
        'criteria',
        'is_active',
    ];

    protected $casts = [
        'min_clv' => 'decimal:2',
        'max_clv' => 'decimal:2',
        'criteria' => 'array',
        'is_active' => 'boolean',
    ];

    protected static function boot()
    {
        parent::boot();

        static::creating(function ($segment) {
            if (empty($segment->slug)) {
                $segment->slug = Str::slug($segment->name);
            }
        });
    }

    public function beautySalon()
    {
        return $this->belongsTo(User::class, 'beauty_salon_id');
    }

    public function clvScores()
    {
        return $this->hasMany(CustomerClvScore::class, 'segment_id');
    }
}
