<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class DynamicPrice extends Model
{
    use HasFactory;

    protected $fillable = [
        'service_id',
        'beauty_salon_id',
        'pricing_rule_id',
        'base_price',
        'dynamic_price',
        'applied_date',
        'applied_time',
        'demand_level',
    ];

    protected $casts = [
        'base_price' => 'decimal:2',
        'dynamic_price' => 'decimal:2',
        'applied_date' => 'date',
    ];

    public function service()
    {
        return $this->belongsTo(Service::class);
    }

    public function beautySalon()
    {
        return $this->belongsTo(User::class, 'beauty_salon_id');
    }

    public function pricingRule()
    {
        return $this->belongsTo(PricingRule::class);
    }
}
