<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Str;

class Invoice extends Model
{
    use HasFactory;

    protected $fillable = [
        'reservation_id',
        'customer_id',
        'invoice_number',
        'total_amount',
        'deposit_paid',
        'remaining_amount',
        'invoice_date',
        'pdf_path',
        'status',
        'items_json',
        'public_token',
        'public_url',
        'created_by',
    ];

    protected $casts = [
        'total_amount' => 'decimal:2',
        'deposit_paid' => 'decimal:2',
        'remaining_amount' => 'decimal:2',
        'invoice_date' => 'date',
        'items_json' => 'array',
    ];

    protected static function boot()
    {
        parent::boot();

        static::creating(function ($invoice) {
            if (empty($invoice->public_token)) {
                $invoice->public_token = Str::random(32);
            }
            if (empty($invoice->public_url)) {
                $url = url('/fatura/' . $invoice->public_token);
                // localhost için salonay/public yolunu kaldır
                if (strpos($url, 'localhost') !== false || strpos($url, '127.0.0.1') !== false) {
                    $url = str_replace('/salonay/public', '', $url);
                }
                $invoice->public_url = $url;
            }
        });
    }

    public function reservation()
    {
        return $this->belongsTo(Reservation::class);
    }

    public function customer()
    {
        return $this->belongsTo(Customer::class);
    }

    public function creator()
    {
        return $this->belongsTo(User::class, 'created_by');
    }
}

