<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class LoyaltyReward extends Model
{
    protected $fillable = [
        'beauty_salon_id',
        'name',
        'description',
        'points_required',
        'reward_type',
        'reward_value',
        'is_active',
        'expires_at',
    ];

    protected $casts = [
        'points_required' => 'decimal:2',
        'reward_value' => 'decimal:2',
        'is_active' => 'boolean',
        'expires_at' => 'datetime',
    ];

    public function beautySalon()
    {
        return $this->belongsTo(User::class, 'beauty_salon_id');
    }
}
