<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class LoyaltyTier extends Model
{
    use HasFactory;

    protected $fillable = [
        'beauty_salon_id',
        'name',
        'level',
        'min_visits',
        'min_spend',
        'points_per_visit',
        'points_per_spend',
        'discount_percentage',
        'priority_booking',
        'benefits',
        'is_active',
        'sort_order',
    ];

    protected $casts = [
        'benefits' => 'array',
        'is_active' => 'boolean',
        'priority_booking' => 'boolean',
        'min_spend' => 'decimal:2',
        'points_per_visit' => 'decimal:2',
        'points_per_spend' => 'decimal:2',
        'discount_percentage' => 'decimal:2',
    ];

    public function beautySalon()
    {
        return $this->belongsTo(User::class, 'beauty_salon_id');
    }

    public function customerLoyalties()
    {
        return $this->hasMany(CustomerLoyalty::class);
    }
}
