<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class MembershipPackage extends Model
{
    use HasFactory;

    protected $fillable = [
        'beauty_salon_id',
        'name',
        'description',
        'period',
        'price',
        'service_limit',
        'amount_limit',
        'allow_rollover',
        'rollover_percentage',
        'priority_booking',
        'included_services',
        'excluded_services',
        'is_active',
    ];

    protected $casts = [
        'price' => 'decimal:2',
        'amount_limit' => 'decimal:2',
        'allow_rollover' => 'boolean',
        'priority_booking' => 'boolean',
        'is_active' => 'boolean',
        'included_services' => 'array',
        'excluded_services' => 'array',
    ];

    public function beautySalon()
    {
        return $this->belongsTo(User::class, 'beauty_salon_id');
    }

    public function memberships()
    {
        return $this->hasMany(CustomerMembership::class);
    }
}
