<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Package extends Model
{
    use HasFactory;

    protected $fillable = [
        'name',
        'description',
        'price',
        'original_price',
        'discount_percentage',
        'price_period',
        'is_popular',
        'is_active',
        'sort_order',
        'features',
        'duration_months',
    ];

    protected $casts = [
        'price' => 'decimal:2',
        'original_price' => 'decimal:2',
        'discount_percentage' => 'integer',
        'is_popular' => 'boolean',
        'is_active' => 'boolean',
        'sort_order' => 'integer',
        'features' => 'array',
        'duration_months' => 'integer',
    ];

    public function getFormattedPriceAttribute()
    {
        if ($this->price == 0) {
            return 'Ücretsiz';
        }
        return number_format($this->price, 2, ',', '.') . ' ₺';
    }

    public function getPricePeriodTextAttribute()
    {
        return $this->price_period === 'monthly' ? 'ay' : 'yıl';
    }
}
