<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class PersonalizedOffer extends Model
{
    use HasFactory;

    protected $fillable = [
        'customer_id',
        'beauty_salon_id',
        'segment_id',
        'offer_name',
        'description',
        'offer_type',
        'discount_percentage',
        'discount_amount',
        'service_id',
        'valid_from',
        'valid_until',
        'status',
        'sent_at',
        'redeemed_at',
        'appointment_id',
    ];

    protected $casts = [
        'discount_percentage' => 'decimal:2',
        'discount_amount' => 'decimal:2',
        'valid_from' => 'date',
        'valid_until' => 'date',
        'sent_at' => 'datetime',
        'redeemed_at' => 'datetime',
    ];

    public function customer()
    {
        return $this->belongsTo(Customer::class);
    }

    public function beautySalon()
    {
        return $this->belongsTo(User::class, 'beauty_salon_id');
    }

    public function segment()
    {
        return $this->belongsTo(CustomerSegment::class);
    }

    public function service()
    {
        return $this->belongsTo(Service::class);
    }
}
