<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class PersonelLeave extends Model
{
    use HasFactory;

    protected $fillable = [
        'beauty_salon_id',
        'personel_id',
        'leave_date',
        'note',
        'created_by',
        'transfer_to_personel_id',
    ];

    protected $casts = [
        'leave_date' => 'date',
    ];

    public function personel()
    {
        return $this->belongsTo(User::class, 'personel_id');
    }

    public function transferPersonel()
    {
        return $this->belongsTo(User::class, 'transfer_to_personel_id');
    }
}

