<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class PriceTest extends Model
{
    protected $fillable = [
        'beauty_salon_id',
        'service_id',
        'test_name',
        'control_price',
        'test_price',
        'control_group_size',
        'test_group_size',
        'start_date',
        'end_date',
        'status',
        'control_conversions',
        'test_conversions',
        'control_revenue',
        'test_revenue',
        'conversion_rate_control',
        'conversion_rate_test',
        'conclusion',
    ];

    protected $casts = [
        'control_price' => 'decimal:2',
        'test_price' => 'decimal:2',
        'start_date' => 'date',
        'end_date' => 'date',
        'control_revenue' => 'decimal:2',
        'test_revenue' => 'decimal:2',
        'conversion_rate_control' => 'decimal:2',
        'conversion_rate_test' => 'decimal:2',
    ];

    public function beautySalon()
    {
        return $this->belongsTo(User::class, 'beauty_salon_id');
    }

    public function service()
    {
        return $this->belongsTo(Service::class);
    }
}
